\
#!/usr/bin/env bash
# isolate-host.sh - Block all outbound except manager (edit IP)
set -euo pipefail
MANAGER_IP="${1:-192.0.2.10}"
# Create a dedicated iptables chain
iptables -N CDB_ISO 2>/dev/null || true
iptables -F CDB_ISO
iptables -A CDB_ISO -d "$MANAGER_IP" -j ACCEPT
iptables -A CDB_ISO -j DROP
# Apply to OUTPUT
iptables -D OUTPUT -j CDB_ISO 2>/dev/null || true
iptables -A OUTPUT -j CDB_ISO
exit 0
