CyberDudeBivash Threat Hunting Utility (CYBERDUDEBIVASH Edition)
==============================================================

This package contains a defensive, alert-first Python utility for real-time threat hunting on endpoints/servers.
It is designed to generate SOC-ready JSONL events that you can ship to Splunk/Elastic/SIEM pipelines.

Package contents
----------------
- src/cyberdudebivash_threat_hunt.py  : Main hunting script (process-behavior monitoring, scoring, JSONL output)
- config/shield_policy.json          : Simple policy/threshold config (edit safely)
- config/allowlist.txt               : Optional allowlist (process names / parent names / paths)
- examples/sample_output.jsonl       : Example JSONL output
- scripts/run_windows.ps1            : Run helper for Windows
- scripts/run_linux.sh               : Run helper for Linux
- scripts/install_service_linux.sh   : systemd service installer (Linux)
- scripts/install_task_windows.ps1   : Task Scheduler installer (Windows)
- requirements.txt                   : Python dependencies
- SECURITY.md                        : Safe usage guidance & boundaries
- LICENSE.txt                        : License placeholder (replace with your CyberDudeBivash license text)

Quick start
-----------
1) Install Python 3.10+ (recommended) and create a virtual environment.

Windows (PowerShell):
  python -m venv .venv
  .\.venv\Scripts\Activate.ps1
  pip install -r requirements.txt

Linux:
  python3 -m venv .venv
  source .venv/bin/activate
  pip install -r requirements.txt

2) Run (alert-first):
  python src/cyberdudebivash_threat_hunt.py --config config/shield_policy.json --out logs/cyberdudebivash_threat_hunt.jsonl

3) Ship logs to your SIEM:
  - Splunk: monitor the JSONL file with a forwarder (sourcetype=c yberdudebivash:shield)
  - Elastic: Filebeat input for JSON lines

Notes
-----
- Default mode is defensive/observe-only. No destructive actions are performed.
- Tune thresholds in config/shield_policy.json.
- Run as least-privileged user where possible. For deeper telemetry, you may need elevated privileges depending on OS.

Brand ecosystem
--------------
Apps & Products: https://www.cyberdudebivash.com/apps-products/
Threat Intel Blog: https://cyberbivash.blogspot.com

Author: Cyberdudebivash
