#!/usr/bin/env bash
set -euo pipefail

# Installs a systemd service named cyberdudebivash-shield.service
# Run: sudo bash scripts/install_service_linux.sh

APP_DIR="$(cd "$(dirname "$0")/.." && pwd)"
SERVICE_PATH="/etc/systemd/system/cyberdudebivash-shield.service"

cat <<EOF | sudo tee "$SERVICE_PATH" >/dev/null
[Unit]
Description=CyberDudeBivash Threat Hunting Utility (Shield)
After=network.target

[Service]
Type=simple
WorkingDirectory=$APP_DIR
ExecStart=$APP_DIR/.venv/bin/python $APP_DIR/src/cyberdudebivash_threat_hunt.py --config $APP_DIR/config/shield_policy.json --out $APP_DIR/logs/cyberdudebivash_threat_hunt.jsonl --allowlist $APP_DIR/config/allowlist.txt
Restart=always
RestartSec=5
User=root

[Install]
WantedBy=multi-user.target
EOF

sudo systemctl daemon-reload
sudo systemctl enable cyberdudebivash-shield.service
sudo systemctl restart cyberdudebivash-shield.service
sudo systemctl status cyberdudebivash-shield.service --no-pager
echo "Installed: cyberdudebivash-shield.service"
