\
# Run in Admin PowerShell to create a scheduled task that starts on boot.
# Task Name: CYBERDUDEBIVASH-Shield

$TaskName = "CYBERDUDEBIVASH-Shield"
$AppDir = (Resolve-Path (Join-Path $PSScriptRoot "..")).Path
$Python = (Join-Path $AppDir ".venv\Scripts\python.exe")
$Args = "src\cyberdudebivash_threat_hunt.py --config config\shield_policy.json --out logs\cyberdudebivash_threat_hunt.jsonl --allowlist config\allowlist.txt"
$Action = New-ScheduledTaskAction -Execute $Python -Argument $Args -WorkingDirectory $AppDir
$Trigger = New-ScheduledTaskTrigger -AtStartup
$Principal = New-ScheduledTaskPrincipal -UserId "SYSTEM" -RunLevel Highest

Register-ScheduledTask -TaskName $TaskName -Action $Action -Trigger $Trigger -Principal $Principal -Force
Write-Host "Installed scheduled task: $TaskName"
